/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef TOOLUTILITIESDIALOGHEADERFILE
#define TOOLUTILITIESDIALOGHEADERFILE

#include <QDialog>

#include "tooldata.h"

class QComboBox;
class QLabel;
class QLineEdit;
class QListWidget;
class QPushButton;
class QCheckBox;
class QToolBox;
class QToolButton;
class QWidget;
class TToolAddAnglesDialog;
class TNameEditDialog;
class TToolBuilderDialog;

class TToolUtilitiesDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TToolUtilitiesDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TToolUtilitiesDialog(void);

// ACCESSORS
	bool Save_Tool_Data(const QString &path) const;
	bool Calibrate_On_Close(void) const {return d_calibrate_on_close;}
	bool Is_Motorized_Probe_Head(void) {return d_tool_data.Is_Motorized_Probe_Head();}
	
	int Tool_Count(void) const;
	TToolData::TTool Tool(const int index) const;
	TToolData::TToolEntry Tool_Entry(const QString &tool_name,const double &angle_a,const double &angle_b,TVector3 * const offset,TVector3 * const vector,bool * valid);
	
	QString Calibrate_Tool_Name(void) const;
	std::vector<TToolData::TToolEntry> Calibrate_Tool_Data(void) const;

// MANIPULATORS
	void Reset(const QString &active_tool_name);
	bool Load_Tool_Data(const QString &path);
	
	void Update_Tool_Tip_Diameter(const QString &tool_name,const double &angle_a,const double &angle_b,const double &tip_diameter);
	
	static void Convert_Angle_Signature(const int angle_ab_signature,double * const angle_a,double * const angle_b);

signals:
	void Invalidate_Active_Tool(void);

private slots:
	void Page_Changed(int);
	void Orientation_Changed(void);
	void Tool_Name_Changed(void);
	void Tool_Add_Name(void);
	void Tool_Remove_Name(void);
	void Configuration_Changed(void);
	void Configuration_Add(void);
	void Configuration_Remove(void);
	void Configuration_Offset_Changed(void);
	void Configuration_Motorized_Head_Changed(bool);
	void ToolData_Name_Changed(void);
	void ToolData_Add_Angle(void);
	void ToolData_Remove_Angle(void);
	void ToolData_Angle_Selection_Changed(void);
	void ToolData_Tip_Diameter_Changed(void);
	void ToolData_Calibrate_Probes(void);

private:
	QToolBox							*d_toolbox;
	QWidget								*d_tool_configuration_page;
	QWidget								*d_tooldata_page;

	QComboBox							*d_orientation_a0b0_combo;
	QComboBox							*d_orientation_a90b0_combo;
	QLabel								*d_orientation_valid_label;
	
	QComboBox							*d_tool_name_combo;
	QToolButton							*d_tool_add_name_button;
	QToolButton							*d_tool_remove_name_button;
	QComboBox							*d_tool_configuration_combo;
	QToolButton							*d_tool_add_configuration_button;
	QToolButton							*d_tool_remove_configuration_button;
	QLineEdit							*d_tool_offset_x_fixed_edit;
	QLineEdit							*d_tool_offset_y_fixed_edit;
	QLineEdit							*d_tool_offset_z_fixed_edit;
	QLineEdit							*d_tool_offset_x_rot_edit;
	QLineEdit							*d_tool_offset_y_rot_edit;
	QLineEdit							*d_tool_offset_z_rot_edit;
	QCheckBox							*d_tool_motorized_head_check;

	QComboBox							*d_tooldata_name_combo;
	QListWidget							*d_tooldata_angles_list;
	QToolButton							*d_tooldata_add_angles_button;
	QToolButton							*d_tooldata_remove_angles_button;
	QLabel								*d_tooldata_offset_x_label;
	QLabel								*d_tooldata_offset_y_label;
	QLabel								*d_tooldata_offset_z_label;
	QLabel								*d_tooldata_vector_i_label;
	QLabel								*d_tooldata_vector_j_label;
	QLabel								*d_tooldata_vector_k_label;
	QLineEdit							*d_tooldata_offset_x_edit;
	QLineEdit							*d_tooldata_offset_y_edit;
	QLineEdit							*d_tooldata_offset_z_edit;
	QLineEdit							*d_tooldata_vector_i_edit;
	QLineEdit							*d_tooldata_vector_j_edit;
	QLineEdit							*d_tooldata_vector_k_edit;
	QLineEdit							*d_tooldata_tip_diameter_edit;
	QLineEdit							*d_tooldata_tip_average_diameter_edit;
	QPushButton							*d_tooldata_calibrate_button;
	
	TNameEditDialog						*d_name_edit_dialog;
	TToolBuilderDialog					*d_tool_builder_dialog;
	TToolAddAnglesDialog				*d_tool_add_angles_dialog;
	
	TToolData							d_tool_data;
	QString								d_active_tool_name;
	double								d_default_tip_diameter;
	bool								d_calibrate_on_close;
	
	void Update_Orientation_Display(void);
	void Initialize_Tool_Page(void);
	void Initialize_Tool_Data_Page(void);


// NOT IMPLEMENTED
	TToolUtilitiesDialog(const TToolUtilitiesDialog&);
	TToolUtilitiesDialog& operator=(const TToolUtilitiesDialog&);
};

#endif
