CONFIG +=			release \
					warn_on \
					qt \
					thread \
					c++11

TEMPLATE =			app
DESTDIR =			../bin

linux-g++{
	DESTDIR =		bin
}

CONFIG(debug, debug|release) {
	TARGET =		measureviewd
} else {
	TARGET =		measureview
}

OBJECTS_DIR =		build/obj
MOC_DIR =			build/moc

QT +=				core \
					gui \
					xml

greaterThan(QT_MAJOR_VERSION, 4): {
QT +=				widgets

}

# DEPENDPATH +=		<relative path>/lib
# INCLUDEPATH +=	<relative path>/src
# LIBS+=			-L<relative path>/lib -l<library name>

SOURCES +=			../../core/graphwidget.cpp \
					../../core/interpolation.cpp \
					../../core/mat4.cpp \
					../../core/messagebox.cpp \
					../../core/referencesystem.cpp \
					../../core/tableeditor.cpp \
					../../core/vector2.cpp \
					../../core/vector3.cpp \
					../../core/xmlfile.cpp \
					src/main.cpp \
					src/measuredata.cpp \
					src/measuredata_ballbar.cpp \
					src/measuredata_ballbar10360.cpp \
					src/measuredata_gaugeblock.cpp \
					src/measuredata_pftu.cpp \
					src/measuredata_pingauge.cpp \
					src/measuredata_tool.cpp \
					src/measuredata_machinelaser10360.cpp \
					src/measuredata_machinelaserpmove.cpp \
					src/measuredata_ringgauge.cpp \
					src/measuredata_rpt.cpp \
					src/measuredata_pointrepeat.cpp \
					src/measuredata_rolloffsettool.cpp \
					src/measuredata_stepgauge10360.cpp \
					src/measuredata_stepgaugeb89.cpp \
					src/measuredata_stepgaugesquare.cpp \
					src/measuredata_temperature.cpp \
					src/measuredata_validationplane.cpp \
					src/measuredata_validationline.cpp \
					src/measuredata_validationcircle.cpp \
					src/measuredata_validationsphere.cpp \
					src/measuredwidget.cpp \
					src/measureview.cpp \
					src/nominaleditordialog.cpp \
					src/nominalwidget.cpp \
					src/measuredinputdialog.cpp \
					src/tolerancedialog.cpp

HEADERS +=			../../core/graphwidget.h \
					../../core/interpolation.h \
					../../core/mat4.h \
					../../core/messagebox.h \
					../../core/referencesystem.h \
					../../core/tableeditor.h \
					../../core/vector2.h \
					../../core/vector3.h \
					../../core/xmlfile.h \
					src/measuredata.h \
					src/measuredata_ballbar.h \
					src/measuredata_ballbar10360.h \
					src/measuredata_gaugeblock.h \
					src/measuredata_pftu.h \
					src/measuredata_pingauge.h \
					src/measuredata_tool.h \
					src/measuredata_machinelaser10360.h \
					src/measuredata_machinelaserpmove.h \
					src/measuredata_ringgauge.h \
					src/measuredata_rpt.h \
					src/measuredata_pointrepeat.h \
					src/measuredata_rolloffsettool.h \
					src/measuredata_stepgauge10360.h \
					src/measuredata_stepgaugeb89.h \
					src/measuredata_stepgaugesquare.h \
					src/measuredata_temperature.h \
					src/measuredata_validationplane.h \
					src/measuredata_validationline.h \
					src/measuredata_validationcircle.h \
					src/measuredata_validationsphere.h \
					src/measuredwidget.h \
					src/measureview.h \
					src/nominaleditordialog.h \
					src/nominalwidget.h \
					src/measuredinputdialog.h \
					src/tolerancedialog.h

RESOURCES +=		res/measureview.qrc

macx{

ICON =				res/icons.icns
QMAKE_INFO_PLIST = ../../default_data/Info.plist
}

linux-g++{

isEmpty(PREFIX) {
PREFIX = 			/usr/lib/measureview
}
target.path =		$$PREFIX
target.files =		bin/measureview
INSTALLS +=			target
}

win32 {
RC_FILE =			res/resource.rc
}
