/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MEASUREDATAHEADERFILE
#define MEASUREDATAHEADERFILE

#include <QIODevice>
#include <QString>
#include <QStringList>
#include <QByteArray>
#include <vector>

#include "../../../core/vector2.h"
#include "../../../core/vector3.h"
#include "../../../core/mat4.h"

class TMeasureData
{
public:

enum TFileType
{
	TYPE_UNKNOWN = 0,
	TYPE_STEPGAUGE_10360,
	TYPE_STEPGAUGE_B89,
	TYPE_STEPGAUGE_SQUARE,
	TYPE_GAUGEBLOCK,
	TYPE_POINT_REPEAT,
	TYPE_SPHERE_RPT,
	TYPE_SPHERE_PFTU,
	TYPE_BALLBAR,
	TYPE_BALLBAR_10360,
	TYPE_RINGGAUGE,
	TYPE_PINGAUGE,
	TYPE_ROLL_OFFSET_TOOL,
	TYPE_PROBE_CALIBRATION,
	TYPE_TEMPERATURE_LOG,
	TYPE_MACHINE_LASER_10360,
	TYPE_MACHINE_LASER_PMOVE,
	TYPE_VALIDATION_PLANE,
	TYPE_VALIDATION_SPHERE,
	TYPE_VALIDATION_CIRCLE,
	TYPE_VALIDATION_LINE
};
	
// CREATORS
	TMeasureData(void);
	virtual ~TMeasureData(void)=0;
	
// ACCESSORS
	TFileType File_Type(void) const {return d_file_type;}
	QString Get_Last_Error(void) const {return d_last_error;}
	
	virtual QString Equipment_Identification(void) const {return QString();}
		
	virtual QStringList Text_Report(void) const {return QStringList();}
	virtual std::vector<std::vector<TVector2> > Graph_Data(void) const {return std::vector<std::vector<TVector2> >();}
	
	static TFileType Determine_File_Contents(const QByteArray &file_data);
	
// MANIPULATORS
	virtual bool Load_Data(const QByteArray &file_data)=0;
	
	virtual bool Set_Nominal_Data(const std::vector<TVector3> &data) {Q_UNUSED(data);return false;}
	
	
protected:
	
	TFileType							d_file_type;
	TMat4								d_alignment_data;
	TVector3							tool_offset;
	TVector3							d_probe_data_vector;
	
	mutable QString						d_last_error;
	
private:
	
enum TFileEncoding
{
	FILE_BINARY = 0,
	FILE_ASCII
};
	
	static TFileEncoding Determine_File_Encoding(const QByteArray &file_data);
	
// NOT IMPLEMENTED
	TMeasureData(const TMeasureData&);
	TMeasureData& operator=(const TMeasureData&);
};

#endif
