/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MEASUREDATA_TEMPERATUREHEADERFILE
#define MEASUREDATA_TEMPERATUREHEADERFILE

#include <vector>
#include <set>

#include "../../../core/vector3.h"
#include "../../../core/vector2.h"

#include "measuredata.h"

class TMeasureTemperature : public TMeasureData
{
public:
	// CREATORS
	TMeasureTemperature(void);
	virtual ~TMeasureTemperature(void);
	
	// ACCESSORS
	
	virtual QStringList Text_Report(void) const;
	virtual std::vector<std::vector<TVector2> > Graph_Data(void) const;
	
	// MANIPULATORS
	virtual bool Load_Data(const QByteArray &file_data);
	
private:
	
struct TSensorData
{
	int									sensor_id;
	int									hour;
	int									minute;
	int									second;
	double								temperature;
};
	
	TVector3							tool_offset;
	TVector3							d_probe_data_vector;
	std::vector<TVector3>				d_points;
	
	std::vector<TSensorData>			d_sensor_data;
	std::set<int>						d_sensor_ids;
	
	std::vector<TSensorData> Get_Sensor_Data(const int sensor_id) const;
	std::vector<double> Get_Sensor_Temperatures(const int sensor_id) const;
	bool Get_Statistics(const std::vector<double> &data,double * const min,double * const max, double * const mean, double * const stdev) const;
	
	// NOT IMPLEMENTED
	TMeasureTemperature(const TMeasureTemperature&);
	TMeasureTemperature& operator=(const TMeasureTemperature&);
};

#endif
