/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include <QApplication>
#include <QStringList>
#include <QByteArray>
#include <QTextStream>

#include "measuredata_validationcircle.h"

TValidationCircle::TValidationCircle(void)
{
}

TValidationCircle::~TValidationCircle(void)
{
}

QStringList TValidationCircle::Text_Report(void) const
{
	QStringList							list;
	QString								text;
	std::vector<TValidationCircle::TResultData>::const_iterator iter;
	
	
	list.push_back(QStringLiteral("Validation Circle Results"));
	list.push_back(QStringLiteral("================================================================"));
	list.push_back(QString());
	
	list.push_back(QStringLiteral("             X            Y            Z         I       J       K          Diameter     Form"));
	list.push_back(QStringLiteral("----------------------------------------------------------------------------------------------"));
	list.push_back(QString());
	
	for(iter = d_result_data.begin();iter != d_result_data.end();++iter)
	{
		text = QString("  Circle %1 %2 %3 %4 %5 %6 %7 %8")
		.arg((*iter).position.x,12,'f',6)
		.arg((*iter).position.y,12,'f',6)
		.arg((*iter).position.z,12,'f',6)
		.arg((*iter).axis.x,7,'f',4)
		.arg((*iter).axis.y,7,'f',4)
		.arg((*iter).axis.z,7,'f',4)
		.arg((*iter).diameter,12,'f',6)
		.arg((*iter).form,12,'f',6);
		
		list.push_back(text);
	}
	
	list.push_back(QString());
	list.push_back(QStringLiteral("Point data for each result included in measurement file."));
	
	
	return list;
}

std::vector<std::vector<TVector2> > TValidationCircle::Graph_Data(void) const
{
	std::vector<std::vector<TVector2> > graph_data;
	
	return graph_data;
}

bool TValidationCircle::Load_Data(
	const QByteArray					&file_data)
{
	QTextStream							stream(file_data,QIODevice::ReadOnly);
	QString								line;
	QString								text;
	QString								text_section;
	QStringList							list;
	bool								init(true);
	TResultData							result;
	
	d_result_data.clear();
	
	while(!stream.atEnd())
	{
		line = stream.readLine().simplified();
		
		if(line.startsWith('#'))
		{
			continue;
		}
		
		if(init)
		{
			if(!line.startsWith(QStringLiteral("Best_Fit_Validation:Version=1:Type=Circle")))
			{
				d_last_error = QStringLiteral("Validation identification line not recognized");
				return false;
			}
			
			init = false;
		}
		else
		{
			if(line.startsWith(QStringLiteral("Circle"),Qt::CaseInsensitive))
			{
				text = line.mid(7);	// remove 'Circle '
				list = text.split(' ');
				
				if(list.size() == 10)
				{
					result.position.x = list[2].toDouble();
					result.position.y = list[3].toDouble();
					result.position.z = list[4].toDouble();

					result.axis.x = list[5].toDouble();
					result.axis.y = list[6].toDouble();
					result.axis.z = list[7].toDouble();

					result.diameter = list[8].toDouble();
					result.form = list[9].toDouble();
					
					d_result_data.push_back(result);
				}
				else
				{
					d_last_error = QStringLiteral("Circle entry format not recognized.");
					return false;
				}
			}
		}
	}
	
	return true;
}
