/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////



#ifndef MEASUREVIEWHEADERFILE
#define MEASUREVIEWHEADERFILE

#include <QMainWindow>

#include "tolerancedialog.h"

class QAction;
class QSettings;
class QCloseEvent;
class QPlainTextEdit;
class QToolButton;
class QFileSystemWatcher;
class TMeasureData;
class TNominalWidget;
class TMeasuredWidget;
class TGraphWidget;
class TMessageBox;

class TMeasureView : public QMainWindow
{
Q_OBJECT

public:

// CREATORS
	TMeasureView(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TMeasureView(void);

// ACCESSORS

// MANIPULATORS
	
protected:
	virtual void closeEvent(QCloseEvent *event);

signals:

private slots:
	void Load_Data(const QString&);							// filename
	void Update_File_List(void);
	void Measure_File_Path_Changed(void);
	
	void Remove_Data(const QString&,const QStringList&);	// filepath, filenames
	void Edit_Tolerance(void);
	void Toggle_Line_Graph_Type(bool);
	void Toggle_Point_Graph_Type(bool);

private:
	QAction								*d_action_quit;
	QPlainTextEdit 						*d_text_display;
	QToolButton							*d_edit_tolerance_button;
	QToolButton							*d_point_graph_button;
	QToolButton							*d_line_graph_button;
	TMeasuredWidget						*d_measured_widget;
	TNominalWidget						*d_stepgauge_nominal_widget;
	TGraphWidget						*d_graph_display;
	TMessageBox							*d_message_box;
	TToleranceDialog					*d_tolerance_dialog;
	QSettings							*d_settings;
	QFileSystemWatcher					*d_file_system_watcher;
	
	TMeasureData						*d_active_data;
	QString								d_active_file_name;
	
	QString								d_application_path;
	QString								d_data_path;
	QString								d_watched_path;

	void Clear_Log(void);
	void Add_Log_Text(const QString &text);
	void Scroll_Log_Top(void);

// NOT IMPLEMENTED
	TMeasureView(const TMeasureView&);
	TMeasureView& operator=(const TMeasureView&);
};

#endif
