/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef NOMINALEDITORDIALOGHEADERFILE
#define NOMINALEDITORDIALOGHEADERFILE

#include <QDialog>
#include <vector>

#include "../../core/vector3.h"

class QLineEdit;
class QPushButton;
class QRadioButton;
class QComboBox;
class TEditTable;

class TNominalEditorDialog : public QDialog
{
Q_OBJECT

public:
	
enum TNominalType
{
	TYPE_1D = 0,
	TYPE_3D
};

// CREATORS
	TNominalEditorDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TNominalEditorDialog(void);

// ACCESSORS
	QString Serial_Number(void) const;
	TNominalType Nominal_Type(void) const {return d_nominal_type;}
	std::vector<TVector3> Nominal_Data(void) const {return d_nominals;}

// MANIPULATORS
	void Reset(const QString &serial,const std::vector<TVector3> &nominals,const TNominalType type);

signals:

private slots:
	
	void Update_Editor(void);
	void Toggle_Mode(bool);
	void Toggle_Type(void);
	void Cell_Changed(const int,const int,const double&);
	void Serial_Changed(const QString&);


private:
	QLineEdit							*d_end_edit;
	QLineEdit							*d_increment_edit;
	QLineEdit							*d_serial_edit;
	QLineEdit							*d_start_edit;
	QPushButton							*d_cancel_button;
	QPushButton							*d_save_button;
	QRadioButton						*d_mode_actual_radio;
	QRadioButton						*d_mode_deviation_radio;
	QComboBox							*d_data_type_combo;
	TEditTable							*d_edit_table;
	
	TNominalType						d_nominal_type;
	std::vector<TVector3>				d_nominals;
	
	void Initialize_Editor(const std::vector<TVector3> &nominals);

// NOT IMPLEMENTED
	TNominalEditorDialog(const TNominalEditorDialog&);
	TNominalEditorDialog& operator=(const TNominalEditorDialog&);
};

#endif
