/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef TOLERANCEDIALOGHEADERFILE
#define TOLERANCEDIALOGHEADERFILE

#include <QDialog>

class QLineEdit;
class QPushButton;

class TToleranceDialog : public QDialog
{
	Q_OBJECT
public:
	
enum TToleranceType
{
	TOLERANCE_BAND=0,
	TOLERANCE_FORMULA,
	TOLERANCE_FORMULA_WITH_LIMIT
};

// CREATORS
	TToleranceDialog(const QWidget *parent=0,Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TToleranceDialog(void);

// ACCESSORS
	TToleranceType Tolerance_Type(void) const {return d_tolerance_type;}

	double Tolerance_A(void) const {return d_tolerance_a;}
	double Tolerance_B(void) const {return d_tolerance_b;}
	double Tolerance_C(void) const {return d_tolerance_c;}
	double Tolerance_D(void) const {return d_tolerance_d;}
	double Lower_Temperature_Limit(void) const {return d_lower_temperature_limit;}
	double Upper_Temperature_Limit(void) const {return d_upper_temperature_limit;}
	
	double Tolerance_Value(const double &length) const;

	double Limit_Position(const double &tolerance_a, // Position where fixed tolerance takes over
								const double &tolerance_b,
								const double &tolerance_c,
								const double &tolerance_d) const;

	inline double Limit_Position(void) const
	{
		return this->Limit_Position(d_tolerance_a,d_tolerance_b,d_tolerance_c,d_tolerance_d);
	}

// MANIPULATORS

	void Set_Tolerance_Type(const TToleranceType &type);

	void Set_Tolerance_A(const double &a);
	void Set_Tolerance_B(const double &b);
	void Set_Tolerance_C(const double &c);
	void Set_Tolerance_D(const double &d);
	void Set_Lower_Temperature_Limit(const double &tolerance);
	void Set_Upper_Temperature_Limit(const double &tolerance);
	
	void Update(void);	// must be called after tolerances set by external means


private slots:
	void Tolerance_Changed(void);

protected:

private:
	QLineEdit 							*d_tolerance_edit;
	QLineEdit 							*d_max_temperature_edit;
	QLineEdit 							*d_min_temperature_edit;
	QPushButton							*d_accept_button;
	TToleranceType						d_tolerance_type;
	double								d_tolerance_a;
	double								d_tolerance_b;
	double								d_tolerance_c;
	double								d_tolerance_d;
	double								d_lower_temperature_limit;
	double								d_upper_temperature_limit;

	void Update_Display(void);

// NOT IMPLEMENTED
	TToleranceDialog(const TToleranceDialog&);
	TToleranceDialog& operator=(const TToleranceDialog&);
};

#endif

