/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef CHANGEHEADERFILE
#define CHANGEHEADERFILE

#include <QWidget>

class QPlainTextEdit;
class TXmlFile;

class TChangeLogWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TChangeLogWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TChangeLogWidget(void);

// ACCESSORS
	QString Last_Error(void) const {return d_last_error;}
	
	bool Save_Defaults(const QString &file_path);

	QString Changes(void) const;

// MANIPULATORS
	bool Load_Defaults(const QString &file_path);
	
	void Clear_Changelog(void);
	void Add_Changelog_Line(const QString &line);


signals:

private slots:

private:
	QPlainTextEdit						*d_changelog_edit;
	
	mutable QString						d_last_error;
	
	void Initialize(void);
			
	void Load_V1(TXmlFile * const xml_file);

// NOT IMPLEMENTED
	TChangeLogWidget(const TChangeLogWidget&);
	TChangeLogWidget& operator=(const TChangeLogWidget&);
};

#endif

