/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef EXPRESSIONESHEADERFILE
#define EXPRESSIONESHEADERFILE

#include <QWidget>

class QLineEdit;

class TXmlFile;

class TExpressionsWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TExpressionsWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TExpressionsWidget(void);

// ACCESSORS
	bool Save_Defaults(const QString &file_path);

	QString Build_Path(void) const;
	QString CMake_Bin_Path(void) const;
	QString QMake_Bin_Path(void) const;
	QString Library_Path(void) const;
	QString Desktop_Menu_Path(void) const;
	QString Target_Install_Path(void) const;
	QString Target_Desktop_Menu_Path(void) const;

// MANIPULATORS
	bool Load_Defaults(const QString &file_path);

signals:

private slots:

private:
	QLineEdit							*d_build_path_edit;
	QLineEdit							*d_cmake_bin_path_edit;
	QLineEdit							*d_qmake_bin_path_edit;
	QLineEdit							*d_library_path_edit;
	QLineEdit							*d_desktop_menu_path_edit;
	QLineEdit							*d_target_install_path_edit;
	QLineEdit							*d_target_desktop_menu_path_edit;

	mutable QString						d_last_error;
	
	void Initialize(void);

	void Load_V1(TXmlFile * const xml_file);

// NOT IMPLEMENTED
	TExpressionsWidget(const TExpressionsWidget&);
	TExpressionsWidget& operator=(const TExpressionsWidget&);
};

#endif
