/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef LIBRARIESHEADERFILE
#define LIBRARIESHEADERFILE

#include <QWidget>
#include <vector>

#include "types.h"

class QTreeWidget;
class QTreeWidgetItem;
class QToolButton;

class TLibraryEditDialog;
class TXmlFile;

class TLibrariesWidget : public QWidget
{
Q_OBJECT

public:
	
struct TTarget
{
	QString								target_name;
	bool								checked;
};

struct TLibrary
{
	QString								target_name;
	QString								library_name;
	TTypes::TLibraryType				type;
	bool								checked;
};

// CREATORS
	TLibrariesWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TLibrariesWidget(void);

// ACCESSORS
	bool Save_Defaults(const QString &file_path);
	
	QStringList Active_Targets(const bool with_active_libraries = false) const;
	QStringList Active_Libraries(const QString &target_name) const;
	TLibrary Library(const QString &target_name,const QString &library_name) const;
	
// MANIPULATORS
	bool Load_Defaults(const QString &file_path);
	
	void Unselect_Targets(void);
	void Unselect_Libaries(void);
	void Select_Target(const QString &name);
	void Select_Library(const QString &target,const QString &library);
	void Update(void);
	
signals:

private slots:
	void Target_Item_Clicked(void);
	void Target_Selection_Changed(void);
	void Library_Item_Clicked(void);
	void Library_Selection_Changed(void);
	void Add_Target(void);
	void Remove_Target(void);
	void Add_Library(void);
	void Remove_Library(void);
	void Edit_Library(void);

private:
	QTreeWidget							*d_target_tree;
	QTreeWidget							*d_libraries_tree;
	QToolButton							*d_add_target_button;
	QToolButton							*d_remove_target_button;
	QToolButton							*d_add_library_button;
	QToolButton							*d_remove_library_button;
	QToolButton							*d_edit_library_button;

	TLibraryEditDialog					*d_library_edit_dialog;
	
	std::vector<TTarget>				d_targets;
	std::vector<TLibrary>				d_libraries;
	mutable QString						d_last_error;

	void Initialize(void);
		
	bool Target_Exists(const QString &name) const;
	bool Library_Exists(const QString &target_name,const QString &library_name) const;
	bool Has_Libraries(const QString &target_name) const;
	QString Library_Plugins(const QString &library_name) const;
	QStringList Target_Names(void) const;

	void Target_Remove(const QString &name);
	void Library_Remove(const QString &target_name,const QString &library_name);
	void Library_Rename(const QString &old_name,const QString &new_name);

	void Update_Target_Tree(void);
	void Update_Target_Data(void);
	void Update_Library_Tree(void);
	void Update_Library_Data(void);
	void Update_Library_Tree_Status(const QStringList &active_targets);
	
	void Load_V1(TXmlFile * const xml_file);

// NOT IMPLEMENTED
	TLibrariesWidget(const TLibrariesWidget&);
	TLibrariesWidget& operator=(const TLibrariesWidget&);
};

#endif

