/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef VARIABLEEDITORHEADERFILE
#define VARIABLEEDITORHEADERFILE

#include <QDialog>

class QLineEdit;
class QPushButton;

class TVariableEditor : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TVariableEditor(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TVariableEditor(void);

// ACCESSORS
	QString Name(void) const;
	QString Value(void) const;

// MANIPULATORS

signals:

private slots:
	void Validate(const QString&);

private:
	QLineEdit							*d_name_edit;
	QLineEdit							*d_value_edit;
	QPushButton							*d_accept_button;
	QPushButton							*d_cancel_button;

// NOT IMPLEMENTED
	TVariableEditor(const TVariableEditor&);
	TVariableEditor& operator=(const TVariableEditor&);
};

#endif
