/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include <QApplication>
#include <QWidget>
#include <QLabel>
#include <QObjectList>
#include <QKeyEvent>

#include "messagebox.h"

TMessageBox::TMessageBox(
	const QWidget 						*parent)
:QMessageBox(const_cast<QWidget*>(parent))
{
	d_label_min_width = 400;
	
	this->setTextFormat(Qt::RichText);
    this->setStyleSheet("dialogbuttonbox-buttons-have-icons: 0;\nbutton-layout: 1;");
}

TMessageBox::~TMessageBox(void)
{
}

void TMessageBox::Send_Key(
	const int							key)
{
	QApplication::postEvent(this,new QKeyEvent(QEvent::KeyPress,key,Qt::NoModifier));
	QApplication::postEvent(this,new QKeyEvent(QEvent::KeyRelease,key,Qt::NoModifier));
}

void TMessageBox::setText(
	const QString 						&text)
{
	QMessageBox::setText(QString("<span style=\"font-weight:600; color:#000000;\" >%1</span>").arg(text));
}

void TMessageBox::setInformativeText(
	const QString 						&text)
{
	QMessageBox::setInformativeText(QString("<span style=\"font-weight:400; color:#000000;\" >%1</span>").arg(text));
}

int TMessageBox::exec(void)
{
	QObjectList							object_list;
	QLabel								*label;
	QObjectList::const_iterator			iter;

	object_list = this->children();
	
	for(iter = object_list.begin();iter != object_list.end();++iter)
	{
		label = qobject_cast<QLabel*>(*iter);
		
		if(label)
		{
			if(label->text().length())	// labels with no text assumed for the icon
			{
				label->setMinimumWidth(d_label_min_width);
			}
			else
			{
				label->setMinimumWidth(0);				
			}
		}
	}
	
	return QMessageBox::exec();
}


