/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef EXPRESSIONESHEADERFILE
#define EXPRESSIONESHEADERFILE

#include <QWidget>
#include <vector>

class QLineEdit;
class QTreeWidget;
class QToolButton;

class TLinkEditDialog;
class TXmlFile;
class TMessageBox;

class TExpressionsWidget : public QWidget
{
Q_OBJECT

public:
	
struct TLink
{
	QString								name;
	QString								path;
	bool								checked;
};

// CREATORS
	TExpressionsWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TExpressionsWidget(void);

// ACCESSORS
	bool Save_Defaults(const QString &file_path);

	QString Build_Path(void) const;
	QString CMake_Bin_Path(void) const;
	QString QMake_Bin_Path(void) const;
	QString Library_Path(void) const;
	QString Desktop_Menu_Path(void) const;
	QString Target_Install_Path(void) const;
	QString Target_Desktop_Menu_Path(void) const;
	QString Target_Additional_Executables(void) const;
	
	int Symbolic_Links_Count(void) const;
	TLink Symbolic_Link(const int index) const;

// MANIPULATORS
	bool Load_Defaults(const QString &file_path);
	void Set_Target_Additional_Executables(const QString &text);
	
	void Uncheck_Symbolic_Links(void);
	void Add_Symbolic_Link(const QString &name,const QString &value);
	void Update_Symbolic_Link_Tree(void);

signals:

private slots:
	void Link_Item_Clicked(void);
	void Link_Selection_Changed(void);
	void Add_Link(void);
	void Remove_Link(void);
	void Edit_Link(void);


private:
	QLineEdit							*d_build_path_edit;
	QLineEdit							*d_cmake_bin_path_edit;
	QLineEdit							*d_qmake_bin_path_edit;
	QLineEdit							*d_library_path_edit;
	QLineEdit							*d_desktop_menu_path_edit;
	QLineEdit							*d_target_install_path_edit;
	QLineEdit							*d_target_desktop_menu_path_edit;
	QLineEdit							*d_target_additional_executables_edit;
	QTreeWidget							*d_links_tree;
	QToolButton							*d_add_link_button;
	QToolButton							*d_remove_link_button;
	QToolButton							*d_edit_link_button;
	TLinkEditDialog						*d_link_edit_dialog;
	TMessageBox							*d_msg_box;

	std::vector<TLink>					d_links;

	mutable QString						d_last_error;
	
	bool Link_Exists(const QString &name) const;

	void Initialize(void);
	void Enable_Link(const QString &name,const bool state);
	void Update_Link_Tree(void);
	void Update_Link_Data(void);
	void Link_Remove(const QString &name);


	void Load_V1(TXmlFile * const xml_file);
	void Load_V2(TXmlFile * const xml_file);

// NOT IMPLEMENTED
	TExpressionsWidget(const TExpressionsWidget&);
	TExpressionsWidget& operator=(const TExpressionsWidget&);
};

#endif
