/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QFrame>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QSpacerItem>
#include <QToolButton>
#include <QFileDialog>
#include <QDir>

#include "linkeditdialog.h"

TLinkEditDialog::TLinkEditDialog(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QDialog(const_cast<QWidget*>(parent),flags)
{
	QFrame								*separator_hline;
	QGridLayout							*dialog_layout;
	QHBoxLayout							*button_hlayout;
	QLabel								*name_label;
	QLabel								*path_label;
	QSpacerItem							*button_hspacer;
	QSpacerItem							*dialog_vspacer;
	QToolButton							*browse_button;


	this->resize(412,170);

	dialog_layout = new QGridLayout(this);
	
	name_label = new QLabel(this);
	name_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	dialog_layout->addWidget(name_label,0,0,1,1);

	d_name_edit = new QLineEdit(this);
	dialog_layout->addWidget(d_name_edit,0,2,1,2);

	path_label = new QLabel(this);
	path_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	dialog_layout->addWidget(path_label,1,0,1,1);

	d_path_edit = new QLineEdit(this);
	dialog_layout->addWidget(d_path_edit,1,2,1,1);

	browse_button = new QToolButton(this);
	dialog_layout->addWidget(browse_button,1,3,1,1);

	separator_hline = new QFrame(this);
	separator_hline->setFrameShape(QFrame::HLine);
	separator_hline->setFrameShadow(QFrame::Sunken);
	dialog_layout->addWidget(separator_hline,3,0,1,4);

	dialog_vspacer = new QSpacerItem(0,0,QSizePolicy::Minimum,QSizePolicy::Expanding);
	dialog_layout->addItem(dialog_vspacer,4,0,1,4);

	button_hlayout = new QHBoxLayout();

	button_hspacer = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Minimum);
	button_hlayout->addItem(button_hspacer);

	d_cancel_button = new QPushButton(this);
	d_cancel_button->setAutoDefault(false);
	button_hlayout->addWidget(d_cancel_button);

	d_accept_button = new QPushButton(this);
	d_accept_button->setAutoDefault(false);
	button_hlayout->addWidget(d_accept_button);
	dialog_layout->addLayout(button_hlayout,5,0,1,4);

	this->setWindowTitle(QStringLiteral("Link Dialog"));
	
	browse_button->setText(QStringLiteral("..."));
	d_cancel_button->setText(QStringLiteral("Cancel"));
	d_accept_button->setText(QStringLiteral("Accept"));
	name_label->setText(QStringLiteral("Name:"));
	path_label->setText(QStringLiteral("Path:"));
	
	connect(browse_button,&QToolButton::clicked,this,&TLinkEditDialog::Browse_Entry);
	connect(d_accept_button,&QPushButton::clicked,this,&TLinkEditDialog::accept);
	connect(d_cancel_button,&QPushButton::clicked,this,&TLinkEditDialog::reject);
}

TLinkEditDialog::~TLinkEditDialog(void)
{
}

QString TLinkEditDialog::Name(void) const
{
	return d_name_edit->text();
}

QString TLinkEditDialog::Path(void) const
{
	return QDir::fromNativeSeparators(d_path_edit->text());
}

void TLinkEditDialog::Set_Name(
	const QString 						&name)
{
	d_name_edit->setText(name);
}

void TLinkEditDialog::Set_Path(
	const QString 						&path)
{
	d_path_edit->setText(QDir::toNativeSeparators(path));
}

void TLinkEditDialog::Reset(
	const TEditMode 					mode)
{
	switch(mode)
	{
		case TLinkEditDialog::MODE_ADD:
			d_name_edit->setText(QString());
			d_path_edit->setText(QString());
			this->setWindowTitle(QStringLiteral("Link Add Dialog"));
			break;
			
		case TLinkEditDialog::MODE_EDIT:
			this->setWindowTitle(QStringLiteral("Link Edit Dialog"));
			break;
	}
}

void TLinkEditDialog::Browse_Entry(void)
{
	QString								path;
	
	path = QFileDialog::getExistingDirectory(this,
											 QStringLiteral("Symbolic Link Path"),
											 QDir::fromNativeSeparators(d_path_edit->text()));
	
	if(path.length())
	{
		d_path_edit->setText(QDir::toNativeSeparators(path));
	}
}
