/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef OPTIONSWIDGETHEADERFILE
#define OPTIONSWIDGETHEADERFILE

#include <QWidget>

#include "types.h"

class QComboBox;
class QLineEdit;
class TXmlFile;

class TOptionsWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TOptionsWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TOptionsWidget(void);

// ACCESSORS
	QString Last_Error(void) const {return d_last_error;}
	TTypes::TOptionMakeGenerator Generator_Type(void) const;
	TTypes::TOptionRequies Requires_Type(void) const;
	QString Shared_Libs_Path(void) const;

	bool Save_Defaults(const QString &file_path);

// MANIPULATORS
	bool Load_Defaults(const QString &file_path);
	
	void Set_Generator_Type(const TTypes::TOptionMakeGenerator type);
	void Set_Requires_Type(const TTypes::TOptionRequies type);
	void Set_Shared_Libs_Path(const QString &path);

signals:
	void Shared_Libs_Path_Changed(const QString &path);

private slots:
	void Browse_Shared_Libs_Path(void);

private:
	QComboBox							*d_generator_combo;
	QComboBox							*d_requires_combo;
	QLineEdit							*d_shared_libs_edit;

	mutable QString						d_last_error;
	
	void Initialize(void);

	void Load_V1(TXmlFile * const xml_file);


// NOT IMPLEMENTED
	TOptionsWidget(const TOptionsWidget&);
	TOptionsWidget& operator=(const TOptionsWidget&);
};

#endif
