/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef REQUIRESWIDGETHEADERFILE
#define REQUIRESWIDGETHEADERFILE

#include <QWidget>
#include <vector>

class QTreeWidget;
class QTreeWidgetItem;
class TXmlFile;

class TRequiresWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TRequiresWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TRequiresWidget(void);

// ACCESSORS
	QString Last_Error(void) const {return d_last_error;}
	QString Shared_Libs_Path(void) const {return d_shared_libs_path;}
	QStringList Required_Packages(void) const;
	QStringList Required_Qt_Libraries(void) const;

	bool Save_Defaults(const QString &file_path);

// MANIPULATORS
	bool Load_Defaults(const QString &file_path);
	
	void Set_Shared_Libs_Path(const QString &path) {d_shared_libs_path = path;}
	void Refresh_Required_Packages(const QStringList &targets);

signals:
	void Refresh(void);

private slots:
	void Clear(void);

private:

struct TRequireEntry
{
	QString								name;
	QStringList							libraries;
};
	
	QTreeWidget							*d_package_tree;
	
	std::vector<TRequireEntry>			d_requires;
	QStringList							d_requires_qt_libraries;
	QString								d_shared_libs_path;
	
	mutable QString						d_last_error;
	
	void Initialize(void);
	void Process_Directory(const QString &path);
	bool Process_File(const QString &file_name);
	bool Has_Library(const QString &library_name);
	void Add_Library(const QString &package_name,const QString &library_name);

	void Update_Tree(void);

	void Load_V1(TXmlFile * const xml_file);
	void Load_V2(TXmlFile * const xml_file);

// NOT IMPLEMENTED
	TRequiresWidget(const TRequiresWidget&);
	TRequiresWidget& operator=(const TRequiresWidget&);
};

#endif
