/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef OPENGLGEOMETRYFACTORYHEADERFILE
#define OPENGLGEOMETRYFACTORYHEADERFILE

#include <vector>

#include "vector3.h"
#include "mat4.h"

class TOpenGLGeometryFactory
{
public:
	
struct TOpenGLTriangleVertex
{
	TVector3							vertex;
	TVector3							normal;
};

	
// CREATORS

	TOpenGLGeometryFactory(void);
	~TOpenGLGeometryFactory(void);

// ACCESSORS
	int Gemetry_Resolution(void) {return d_geometry_resolution;}
	
	// Front face winding of input points is CCW

	std::vector<TOpenGLTriangleVertex> RenderSphere(const TVector3 &position,const double &radius);
	std::vector<TOpenGLTriangleVertex> RenderCylinder(const TVector3 &position,const TVector3 &axis,const double &radius,const double &length);
	std::vector<TOpenGLTriangleVertex> RenderPlane(const TVector3 &p1,const TVector3 &p2,const TVector3 &p3,const TVector3 &p4);
	std::vector<TOpenGLTriangleVertex> RenderCircularPlane(const TVector3 &position,const TVector3 &axis,const TVector3 &reference_axis,const double &radius);
	std::vector<TOpenGLTriangleVertex> RenderPolygon(const TVector3 &position,const TVector3 &axis,const TVector3 &reference_axis,const double &max_radius,const double &length,const int &side_count);
	

// MANIPULATORS
	void Set_Geometry_Resolution(const int i) {d_geometry_resolution = i;}

	
	
private:
	
	int									d_geometry_resolution;

	
	void RenderSphereTriangle(const TVector3 &p1,
									const TVector3 &p2,
									const TVector3 &p3,
									const TVector3 &position,
									const double &radius,
									const int resolution,
									std::vector<TOpenGLTriangleVertex> * const triangle_points) const;
	
	void RenderCircleTriangle(const TVector3 &p1,
									const TVector3 &p2,
									const TVector3 &p3,
									const TVector3 &position,
									const double &radius,
									const int resolution,
									const TMat4 &rotation_matrix,
									std::vector<TOpenGLTriangleVertex> * const triangle_points) const;
	
	void RenderPlaneTriangle(const TVector3 &p1,
									const TVector3 &p2,
									const TVector3 &p3,
									const int resolution,
									std::vector<TOpenGLTriangleVertex> * const triangle_points) const;
	
	void RenderPlaneTriangle(const TVector3 &p1,
									const TVector3 &p2,
									const TVector3 &p3,
									const double &radius_1,
									const double &radius_2,
									const double &radius_3,
									const int resolution,
									std::vector<TOpenGLTriangleVertex> * const triangle_points) const;
	
	TVector3 Normalize_XY(const TVector3 &P) const;

};

#endif
