/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef OPENGLVERTEXBUFFERHEADERFILE
#define OPENGLVERTEXBUFFERHEADERFILE

#include <vector>

class TOpenGLVertexBuffer
{
public:
// CREATORS
	TOpenGLVertexBuffer(void);
	~TOpenGLVertexBuffer(void);
	
// ACCESSORS
	bool Has_Buffer(const int id) const;
	double* Buffer(const int id) const;
	unsigned int Buffer_Size(const int id) const;
	
// MANIPULATORS
	int Create_Buffer(const unsigned int size);
	void Remove_Buffer(const int id);
	void Clear(void);
	
private:
	
struct TBufferItem
{
	int									id;
	unsigned int						size;
	double								*buffer;
};
	
	int									d_next_id;
	std::vector<TBufferItem>			d_buffer_items;
	
// NOT IMPLEMENTED
	TOpenGLVertexBuffer(const TOpenGLVertexBuffer&);
	TOpenGLVertexBuffer& operator=(const TOpenGLVertexBuffer&);
};

#endif
