/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef COMMANDEXECUTORHEADERFILE
#define COMMANDEXECUTORHEADERFILE

#include <QString>
#include <QByteArray>
#include <vector>

#include "../../core/vector3.h"

class TCommandExecutor
{
public:
	
enum TCommandStatus
{
	COMMAND_IDLE = 0,
	COMMAND_EXECUTING,
	COMMAND_COMPLETE
};
	
	
enum TCommandType
{
	COMMAND_MOVE = 0,
	COMMAND_TOUCH,
	COMMAND_DEFINE_MOVECIR_CENTER,
	COMMAND_MOVECIR,
	COMMAND_GETPOS
};
	
struct TCommand
{
	TCommandType						command_type;
	TVector3							target;
	QString								completion_text;
	double								speed;
};
// CREATORS
	TCommandExecutor(void);
	~TCommandExecutor(void);
	
// ACCESSORS
	TCommandStatus Command_Status(void) const {return d_command_status;}
	TVector3 Current_Position(void) const {return d_current_position;}
	TVector3 Target_Position(void) const {return d_target_position;}
	
	QByteArray Completion_Text(void) const {return d_active_command.completion_text.toLatin1();}
	TCommandType Command_Type(void) const {return d_active_command.command_type;}
	
// MANIPULATORS
	void Add_Command(const TCommand &command);
	void Set_Current_Position(const TVector3 &current_position);
	
	TVector3 Execute(void);		// returns new position of machine
	bool Execute_Next(void);
	void Abort(void);
	
	void Set_Timer_Interval(const int interval);	// interval in ms
	
private:
	TVector3							d_current_position;
	TVector3							d_target_position;
	TVector3							d_movecir_center;
	TVector3							d_move_axis;
	int									d_timer_interval;
	double								d_speed;
	TCommand							d_active_command;
	TCommandStatus						d_command_status;
	
	std::vector<TCommand>				d_command_queue;
	
	void Set_Target(const TVector3 &target_position);
	void Set_Speed(const double &dval);
	
	std::vector<TCommand> Move_Arc(const TVector3 &target,const double &move_speed) const;

	
// NOT IMPLEMENTED
	TCommandExecutor(const TCommandExecutor&);
	TCommandExecutor& operator=(const TCommandExecutor&);
};

#endif
