/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QFont>
#include <QGridLayout>
#include <QLabel>
#include <QSizePolicy>
#include <QFontMetrics>
#include <QSpacerItem>

#include "coordinatewidget.h"

#include "coordinatedisplaywidget.h"

TCoordinateDisplayWidget::TCoordinateDisplayWidget(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QWidget(const_cast<QWidget*>(parent),flags)
{
	QFont								font;
	QGridLayout							*widget_layout;
	QLabel								*x_label;
	QLabel								*y_label;
	QLabel								*z_label;
	QLabel								*a_label;
	QLabel								*b_label;
	QLabel								*px_label;
	QLabel								*py_label;
	QLabel								*pz_label;
	QLabel								*pd_label;
	QSizePolicy							size_policy_maximum_preferred(QSizePolicy::Maximum,QSizePolicy::Preferred);
	int									display_width;

	size_policy_maximum_preferred.setHorizontalStretch(0);
	size_policy_maximum_preferred.setVerticalStretch(0);

	font.setPointSize(18);
	
	QFontMetrics font_metrics(font);
	display_width = font_metrics.averageCharWidth() * 16;

	widget_layout = new QGridLayout(this);
	
	x_label = new QLabel(this);
	x_label->setSizePolicy(size_policy_maximum_preferred);
	x_label->setFont(font);
	x_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(x_label,0,0,1,1);

	d_x_value_label = new TCoordinateWidget(this);
	d_x_value_label->setFont(font);
	d_x_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_x_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_x_value_label,0,1,1,1);

	y_label = new QLabel(this);
	y_label->setSizePolicy(size_policy_maximum_preferred);
	y_label->setFont(font);
	y_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(y_label,1,0,1,1);

	d_y_value_label = new TCoordinateWidget(this);
	d_y_value_label->setFont(font);
	d_y_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_y_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_y_value_label,1,1,1,1);

	z_label = new QLabel(this);
	z_label->setSizePolicy(size_policy_maximum_preferred);
	z_label->setFont(font);
	z_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(z_label,2,0,1,1);

	d_z_value_label = new TCoordinateWidget(this);
	d_z_value_label->setFont(font);
	d_z_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_z_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_z_value_label,2,1,1,1);
	
	a_label = new QLabel(this);
	a_label->setSizePolicy(size_policy_maximum_preferred);
	a_label->setFont(font);
	a_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(a_label,3,0,1,1);
	
	d_a_value_label = new TCoordinateWidget(this);
	d_a_value_label->setFont(font);
	d_a_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_a_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_a_value_label,3,1,1,1);
	
	b_label = new QLabel(this);
	b_label->setSizePolicy(size_policy_maximum_preferred);
	b_label->setFont(font);
	b_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(b_label,4,0,1,1);
	
	d_b_value_label = new TCoordinateWidget(this);
	d_b_value_label->setFont(font);
	d_b_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_b_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_b_value_label,4,1,1,1);
	
	px_label = new QLabel(this);
	px_label->setSizePolicy(size_policy_maximum_preferred);
	px_label->setFont(font);
	px_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(px_label,5,0,1,1);
	
	d_px_value_label = new TCoordinateWidget(this);
	d_px_value_label->setFont(font);
	d_px_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_px_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_px_value_label,5,1,1,1);
	
	py_label = new QLabel(this);
	py_label->setSizePolicy(size_policy_maximum_preferred);
	py_label->setFont(font);
	py_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(py_label,6,0,1,1);
	
	d_py_value_label = new TCoordinateWidget(this);
	d_py_value_label->setFont(font);
	d_py_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_py_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_py_value_label,6,1,1,1);
	
	pz_label = new QLabel(this);
	pz_label->setSizePolicy(size_policy_maximum_preferred);
	pz_label->setFont(font);
	pz_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(pz_label,7,0,1,1);
	
	d_pz_value_label = new TCoordinateWidget(this);
	d_pz_value_label->setFont(font);
	d_pz_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_pz_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_pz_value_label,7,1,1,1);
	
	pd_label = new QLabel(this);
	pd_label->setSizePolicy(size_policy_maximum_preferred);
	pd_label->setFont(font);
	pd_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(pd_label,8,0,1,1);
	
	d_pd_value_label = new TCoordinateWidget(this);
	d_pd_value_label->setFont(font);
	d_pd_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_pd_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_pd_value_label,8,1,1,1);

	d_x_value_label->Set_Precision(4);
	d_y_value_label->Set_Precision(4);
	d_z_value_label->Set_Precision(4);
	d_a_value_label->Set_Precision(1);
	d_b_value_label->Set_Precision(1);
	d_px_value_label->Set_Precision(4);
	d_py_value_label->Set_Precision(4);
	d_pz_value_label->Set_Precision(4);
	d_pd_value_label->Set_Precision(4);
	
	x_label->setText(QStringLiteral("X:"));
	y_label->setText(QStringLiteral("Y:"));
	z_label->setText(QStringLiteral("Z:"));
	a_label->setText(QStringLiteral("A:"));
	b_label->setText(QStringLiteral("B:"));
	px_label->setText(QStringLiteral("Tool X:"));
	py_label->setText(QStringLiteral("Tool Y:"));
	pz_label->setText(QStringLiteral("Tool Z:"));
	pd_label->setText(QStringLiteral("Tool D:"));
}

TCoordinateDisplayWidget::~TCoordinateDisplayWidget(void)
{
}

TVector3 TCoordinateDisplayWidget::Position(void) const
{
	TVector3							position;
	
	position.x = d_x_value_label->Value();
	position.y = d_y_value_label->Value();
	position.z = d_z_value_label->Value();
	
	return position;
}

TVector3 TCoordinateDisplayWidget::Tool_Offset(void) const
{
	TVector3							offset;
	
	offset.x = d_px_value_label->Value();
	offset.y = d_py_value_label->Value();
	offset.z = d_pz_value_label->Value();
	
	return offset;
}

double TCoordinateDisplayWidget::Head_A(void) const
{
	return d_a_value_label->Value();
}

double TCoordinateDisplayWidget::Head_B(void) const
{
	return d_b_value_label->Value();
}

double TCoordinateDisplayWidget::Tip_Diameter(void) const
{
	return d_pd_value_label->Value();
}

void TCoordinateDisplayWidget::Set_X(
	const double						&value)
{
	d_x_value_label->Set_Value(value);
}

void TCoordinateDisplayWidget::Set_Y(
	const double						&value)
{
	d_y_value_label->Set_Value(value);
}

void TCoordinateDisplayWidget::Set_Z(
	const double						&value)
{
	d_z_value_label->Set_Value(value);
}

void TCoordinateDisplayWidget::Set_A(
	const double						&a)
{
	d_a_value_label->Set_Value(a);
}

void TCoordinateDisplayWidget::Set_B(
	const double						&b)
{
	d_b_value_label->Set_Value(b);
}

void TCoordinateDisplayWidget::Set_Tool_X(
	const double						&value)
{
	d_px_value_label->Set_Value(value);
}

void TCoordinateDisplayWidget::Set_Tool_Y(
	const double						&value)
{
	d_py_value_label->Set_Value(value);
}

void TCoordinateDisplayWidget::Set_Tool_Z(
	const double						&value)
{
	d_pz_value_label->Set_Value(value);
}

void TCoordinateDisplayWidget::Set_Tool_Tip_Diameter(
	const double						&value)
{
	d_pd_value_label->Set_Value(value);
}

void TCoordinateDisplayWidget::Set_XYZ(
	const TVector3						&xyz)
{
	d_x_value_label->Set_Value(xyz.x);
	d_y_value_label->Set_Value(xyz.y);
	d_z_value_label->Set_Value(xyz.z);
}

void TCoordinateDisplayWidget::Set_Head_AB(
	const double						&a,
	const double						&b)
{
	d_a_value_label->Set_Value(a);
	d_b_value_label->Set_Value(b);
}

void TCoordinateDisplayWidget::Set_Tool(
	const TVector3						&pxyz,
	const double						&diameter)
{
	d_px_value_label->Set_Value(pxyz.x);
	d_py_value_label->Set_Value(pxyz.y);
	d_pz_value_label->Set_Value(pxyz.z);
	d_pd_value_label->Set_Value(diameter);
}
