/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QFrame>
#include <QGridLayout>
#include <QLabel>
#include <QPushButton>
#include <QSizePolicy>
#include <QToolButton>
#include <QIcon>
#include <QPixmap>

#include "jogboxdialog.h"

TJogboxDialog::TJogboxDialog(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QDialog(const_cast<QWidget*>(parent),flags)
{
	QFrame								*lower_separator_line;
	QFrame								*upper_separator_line;
	QGridLayout							*dialog_layout;
	QLabel								*xy_label;
	QLabel								*z_label;
	QSizePolicy							size_policy_fixed_fixed(QSizePolicy::Fixed,QSizePolicy::Fixed);

	size_policy_fixed_fixed.setHorizontalStretch(0);
	size_policy_fixed_fixed.setVerticalStretch(0);

	this->resize(254,448);

	dialog_layout = new QGridLayout(this);
	dialog_layout->setSpacing(4);

	d_xp_button = new QToolButton(this);
	d_xp_button->setMinimumSize(64,64);
	d_xp_button->setMaximumSize(64,64);
	d_xp_button->setAutoRepeat(true);
	d_xp_button->setIconSize(QSize(64,64));
	dialog_layout->addWidget(d_xp_button,1,2,1,1);
	
	d_xm_button = new QToolButton(this);
	d_xm_button->setMinimumSize(64,64);
	d_xm_button->setMaximumSize(64,64);
	d_xm_button->setAutoRepeat(true);
	d_xm_button->setIconSize(QSize(64,64));
	dialog_layout->addWidget(d_xm_button,1,0,1,1);
	
	d_yp_button = new QToolButton(this);
	d_yp_button->setMinimumSize(64,64);
	d_yp_button->setMaximumSize(64,64);
	d_yp_button->setAutoRepeat(true);
	d_yp_button->setIconSize(QSize(64,64));
	dialog_layout->addWidget(d_yp_button,0,1,1,1);
	
	d_ym_button = new QToolButton(this);
	d_ym_button->setMinimumSize(64,64);
	d_ym_button->setMaximumSize(64,64);
	d_ym_button->setAutoRepeat(true);
	d_ym_button->setIconSize(QSize(64,64));
	dialog_layout->addWidget(d_ym_button,2,1,1,1);

	d_zm_button = new QToolButton(this);
	d_zm_button->setMinimumSize(64,64);
	d_zm_button->setMaximumSize(64,64);
	d_zm_button->setAutoRepeat(true);
	d_zm_button->setIconSize(QSize(64,64));
	dialog_layout->addWidget(d_zm_button,2,3,1,1);
	
	d_zp_button = new QToolButton(this);
	d_zp_button->setMinimumSize(64,64);
	d_zp_button->setMaximumSize(64,64);
	d_zp_button->setAutoRepeat(true);
	d_zp_button->setIconSize(QSize(64,64));
	dialog_layout->addWidget(d_zp_button,0,3,1,1);

	xy_label = new QLabel(this);
	xy_label->setSizePolicy(size_policy_fixed_fixed);
	xy_label->setMinimumSize(64,64);
	xy_label->setMaximumSize(64,64);
	xy_label->setFrameShape(QFrame::StyledPanel);
	dialog_layout->addWidget(xy_label,1,1,1,1);
	
	z_label = new QLabel(this);
	z_label->setSizePolicy(size_policy_fixed_fixed);
	z_label->setMinimumSize(64,64);
	z_label->setMaximumSize(64,64);
	z_label->setFrameShape(QFrame::StyledPanel);
	dialog_layout->addWidget(z_label,1,3,1,1);

	upper_separator_line = new QFrame(this);
	upper_separator_line->setFrameShape(QFrame::HLine);
	upper_separator_line->setFrameShadow(QFrame::Sunken);
	dialog_layout->addWidget(upper_separator_line,3,0,1,4);
	
	d_estop_button = new QPushButton(this);
	d_estop_button->setSizePolicy(size_policy_fixed_fixed);
	d_estop_button->setMinimumSize(150,150);
	d_estop_button->setMaximumSize(500,150);
	d_estop_button->setAutoDefault(false);
	d_estop_button->setFlat(true);
	d_estop_button->setIconSize(QSize(116,116));
	dialog_layout->addWidget(d_estop_button,4,0,1,4);

	lower_separator_line = new QFrame(this);
	lower_separator_line->setFrameShape(QFrame::HLine);
	lower_separator_line->setFrameShadow(QFrame::Sunken);
	dialog_layout->addWidget(lower_separator_line,5,0,1,4);

	d_done_button = new QToolButton(this);
	d_done_button->setMinimumSize(64,64);
	d_done_button->setIconSize(QSize(64,64));
	dialog_layout->addWidget(d_done_button,6,0,1,1);
	
	d_erase_hit_button = new QToolButton(this);
	d_erase_hit_button->setMinimumSize(64,64);
	d_erase_hit_button->setIconSize(QSize(64,64));
	dialog_layout->addWidget(d_erase_hit_button,6,1,1,1);
	
	d_mstart_button = new QToolButton(this);
	d_mstart_button->setMinimumSize(64,64);
	d_mstart_button->setMaximumSize(64,64);
	d_mstart_button->setIconSize(QSize(64,64));
	dialog_layout->addWidget(d_mstart_button,6,3,1,1);
	
	// defaults
	d_estop = false;

	this->setWindowTitle(QStringLiteral("Jogbox"));
	
	d_xm_button->setIcon(QIcon(":/jogbox/jog_xm.png"));
	d_xp_button->setIcon(QIcon(":/jogbox/jog_xp.png"));
	d_ym_button->setIcon(QIcon(":/jogbox/jog_ym.png"));
	d_yp_button->setIcon(QIcon(":/jogbox/jog_yp.png"));
	d_zm_button->setIcon(QIcon(":/jogbox/jog_zm.png"));
	d_zp_button->setIcon(QIcon(":/jogbox/jog_zp.png"));
	
	xy_label->setPixmap(QPixmap(":/jogbox/jog_stick.png"));
	z_label->setPixmap(QPixmap(":/jogbox/jog_stick.png"));
	
	d_mstart_button->setIcon(QIcon(":/jogbox/jog_mstart.png"));
	d_estop_button->setIcon(QIcon(":/jogbox/jog_estop_off.png"));
	d_done_button->setIcon(QIcon(":/jogbox/jog_done.png"));
	d_erase_hit_button->setIcon(QIcon(":/jogbox/jog_delpnt.png"));
	
	connect(d_done_button,&QToolButton::clicked,this,&TJogboxDialog::Done_Pressed);
	connect(d_erase_hit_button,&QToolButton::clicked,this,&TJogboxDialog::DelPnt_Pressed);
	
	connect(d_mstart_button,&QToolButton::clicked,this,&TJogboxDialog::MStart_Clicked);
	connect(d_estop_button,&QToolButton::clicked,this,&TJogboxDialog::EStop_Clicked);
	
	connect(d_xm_button,&QToolButton::clicked,this,&TJogboxDialog::Move_XM);
	connect(d_xp_button,&QToolButton::clicked,this,&TJogboxDialog::Move_XP);
	connect(d_ym_button,&QToolButton::clicked,this,&TJogboxDialog::Move_YM);
	connect(d_yp_button,&QToolButton::clicked,this,&TJogboxDialog::Move_YP);
	connect(d_zm_button,&QToolButton::clicked,this,&TJogboxDialog::Move_ZM);
	connect(d_zp_button,&QToolButton::clicked,this,&TJogboxDialog::Move_ZP);
}

TJogboxDialog::~TJogboxDialog(void)
{
}


void TJogboxDialog::MStart_Clicked(void)
{
	if(d_estop)
	{
		d_estop = false;

		d_mstart_button->setIcon(QIcon(":/jogbox/jog_mstart.png"));
		d_estop_button->setIcon(QIcon(":/jogbox/jog_estop_off.png"));

		emit MStart_Pressed();
	}
}

void TJogboxDialog::EStop_Clicked(void)
{
	d_estop = true;
	
	d_mstart_button->setIcon(QIcon(":/jogbox/jog_mstart_off.png"));
	d_estop_button->setIcon(QIcon(":/jogbox/jog_estop.png"));

	emit EStop_Pressed();
}


