/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef JOGBOXDIALOGHEADERFILE
#define JOGBOXDIALOGHEADERFILE

#include <QDialog>

class QPushButton;
class QToolButton;

class TJogboxDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TJogboxDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TJogboxDialog(void);

// ACCESSORS
	bool EStop(void) const {return d_estop;}

// MANIPULATORS

signals:
	void MStart_Pressed(void);
	void DelPnt_Pressed(void);
	void Done_Pressed(void);
	void EStop_Pressed(void);
	
	void Move_XM(void);
	void Move_XP(void);
	void Move_YP(void);
	void Move_YM(void);
	void Move_ZP(void);
	void Move_ZM(void);

private slots:
	
	void MStart_Clicked(void);
	void EStop_Clicked(void);

private:
	QPushButton							*d_estop_button;
	QToolButton							*d_erase_hit_button;
	QToolButton							*d_done_button;
	QToolButton							*d_mstart_button;
	QToolButton							*d_xm_button;
	QToolButton							*d_xp_button;
	QToolButton							*d_ym_button;
	QToolButton							*d_yp_button;
	QToolButton							*d_zm_button;
	QToolButton							*d_zp_button;
	
	bool								d_estop;

// NOT IMPLEMENTED
	TJogboxDialog(const TJogboxDialog&);
	TJogboxDialog& operator=(const TJogboxDialog&);
};

#endif
