/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef MACHINEDCCHEADERFILE
#define MACHINEDCCHEADERFILE

#include "machine.h"

class TMachineDC : public TMachine
{
Q_OBJECT
	
public:
	// CREATORS
	TMachineDC(void);
	virtual ~TMachineDC(void);
	
	// ACCESSORS
	virtual QString Machine_Description(void) const {return QStringLiteral("DC");}

	// MANIPULATORS
	virtual void Process_Rx(const QByteArray &new_data);
	virtual QByteArray KeyPress_Done(void) const;
	virtual QByteArray KeyPress_DelPnt(void) const;

	virtual void Set_EStop(const bool state);
	virtual bool Move_To(const TVector3 &pos);
	virtual bool Manual_Touch(const TVector3 &pos,const TVector3 &vec);
	virtual bool Jog_Move(const TVector3 &direction);

private:
	
	QByteArray							d_rx_data;
	bool								d_geo_enabled;
	bool								d_shift_out_enabled;

	TVector3 Get_Move_Data(const QString &text) const;
	double Get_Move_Speed(const QString &text) const;
	bool Get_Touch_Data(const QString &text,TVector3 * const xyz,TVector3 * const ijk) const;
	bool Get_Head_Angles(const QString &text,double * const a,double * const b) const;

	void Update_Touch_Parameters(const QString &text);
	void Update_Tool_Data(const QString &text);

	
	// NOT IMPLEMENTED
	TMachineDC(const TMachineDC&);
	TMachineDC& operator=(const TMachineDC&);
};

#endif
