/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef MACHINEDOCKHEADERFILE
#define MACHINEDOCKHEADERFILE

#include <QWidget>

#include "../../core/vector3.h"

class QDockWidget;
class QLineEdit;
class QListWidget;
class QSpinBox;
class QDoubleSpinBox;
class QToolButton;
class QLabel;
class QCheckBox;
class TMachineAttributesWidget;

class TMachineDock : public QObject
{
	Q_OBJECT
	
public:
	// CREATORS
	TMachineDock(const QWidget *parent);
	~TMachineDock(void);
	
	// ACCESSORS
	QDockWidget* Dock_Widget(void) {return d_machine_dock;}
	
	TVector3 Min_Machine(void) const;
	TVector3 Max_Machine(void) const;
	double Temperature_X(void) const;
	double Temperature_Y(void) const;
	double Temperature_Z(void) const;
	double Temperature_Part(void) const;
	bool Machine_Errors_Enabled(void) const;
	bool Override_Tip_Enabled(void) const;
	double Tip_Diameter(void) const;
	bool Generate_Noise_Enabled(void) const;
	double Noise_Value(void) const;
	TVector3 Move_Position(void) const;
	int Touch_Buffer_Size(void) const;
	
	// MANIPULATORS
	void Set_Min_Machine(const TVector3 &pnt);
	void Set_Max_Machine(const TVector3 &pnt);
	void Set_Temperature_X(const double &value);
	void Set_Temperature_Y(const double &value);
	void Set_Temperature_Z(const double &value);
	void Set_Temperature_Part(const double &value);
	void Set_Tip_Diameter(const double &value);
	void Set_Noise(const double &value);
	void Enable_Machine_Errors(const bool state);
	void Enable_Override_Tip(const bool state);
	void Enable_Noise(const bool state);
	void Set_Move_Position(const TVector3 &pnt);
	void Set_Touch_Buffer_Size(const int buffer_size);
	
	void Enable_Protocol(const bool state);
	void Set_Serial_Connect_Button(const bool enabled,const QString &text = QString());
	
signals:
	void Attribute_Changed(void);
	void Touch_Buffer_Changed(int);
	void Show_Hide_Jogbox(void);
	void Edit_Machine_Errors(void);
	void Move(const double&,const double&,const double&);	// x,y,z
	void Change_Protocol(void);
	void Connect_Serial(void);
	void Enable_Machine_Errors_Changed(const bool);
	void Override_Tip_State_Changed(const bool);
	void Generate_Noise_State_Changed(const bool);
	void Override_Tip_Diameter_Changed(const double&);
	void Generate_Noise_Value_Changed(const double&);

private slots:
	void Move_Clicked(void);

private:
	
	QDockWidget							*d_machine_dock;
	QWidget								*d_machine_widget;
	QToolButton							*d_protocol_button;
	QToolButton							*d_serial_connect_button;
	QLabel								*d_protocol_label;
	TMachineAttributesWidget			*d_machine_attributes_widget;
	QLineEdit							*d_move_x_edit;
	QLineEdit							*d_move_y_edit;
	QLineEdit							*d_move_z_edit;
	QCheckBox							*d_machine_errors_check;
	QCheckBox							*d_override_tip_check;
	QCheckBox							*d_generate_noise_check;
	QDoubleSpinBox						*d_override_tip_spin;
	QDoubleSpinBox						*d_generate_noise_spin;
	QSpinBox							*d_touch_buffer_spin;
	
	// NOT IMPLEMENTED
	TMachineDock(const TMachineDock&);
	TMachineDock& operator=(const TMachineDock&);
};

#endif
