/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MACHINEERRORSDIALOGHEADERFILE
#define MACHINEERRORSDIALOGHEADERFILE

#include <QDialog>

class QLineEdit;
class QPushButton;
class QCheckBox;

class TMachineErrorsDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TMachineErrorsDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TMachineErrorsDialog(void);

// ACCESSORS
	double Scale_X(void) const;
	double Scale_Y(void) const;
	double Scale_Z(void) const;
	double Squareness_XY(void) const;
	double Squareness_YZ(void) const;
	double Squareness_ZX(void) const;
	bool Correct_Ballbar(void) const;

// MANIPULATORS
	
	void Set_Scale_X(const double &error);
	void Set_Scale_Y(const double &error);
	void Set_Scale_Z(const double &error);
	void Set_Squareness_XY(const double &error);
	void Set_Squareness_YZ(const double &error);
	void Set_Squareness_ZX(const double &error);
	void Set_Correct_Ballbar(const bool state);

signals:

private slots:

private:
	QCheckBox							*d_correct_ballbar_check;
	QLineEdit							*d_scale_x_edit;
	QLineEdit							*d_scale_y_edit;
	QLineEdit							*d_scale_z_edit;
	QLineEdit							*d_squareness_xy_edit;
	QLineEdit							*d_squareness_yz_edit;
	QLineEdit							*d_squareness_zx_edit;
	QPushButton							*d_accept_button;

// NOT IMPLEMENTED
	TMachineErrorsDialog(const TMachineErrorsDialog&);
	TMachineErrorsDialog& operator=(const TMachineErrorsDialog&);
};

#endif
