/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef OPENGLDISPLAYHEADERFILE
#define OPENGLDISPLAYHEADERFILE

#include <vector>

#include "../../core/openglwidget.h"
#include "../../core/openglvertexbuffer.h"
#include "../../core/openglgeometryfactory.h"

class QOpenGLShaderProgram;

class TOpenGLDisplay : public TOpenGLWidget
{
Q_OBJECT
public:
	
struct TMachine
{
	std::vector<TOpenGLGeometryFactory::TOpenGLTriangleVertex>	machine_z;
	std::vector<TOpenGLGeometryFactory::TOpenGLTriangleVertex> 	machine_xz;
	std::vector<TOpenGLGeometryFactory::TOpenGLTriangleVertex> 	machine_x;
	std::vector<TOpenGLGeometryFactory::TOpenGLTriangleVertex> 	machine_xw;
	std::vector<TOpenGLGeometryFactory::TOpenGLTriangleVertex> 	machine_table;
};
	
struct TSensor
{
	std::vector<TOpenGLGeometryFactory::TOpenGLTriangleVertex>	probe_head;
	std::vector<TOpenGLGeometryFactory::TOpenGLTriangleVertex>	tool_stem;
	std::vector<TOpenGLGeometryFactory::TOpenGLTriangleVertex>	tool_ruby;
};

// CREATORS
	TOpenGLDisplay(const QWidget *parent=0,Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TOpenGLDisplay(void);

// ACCESSORS

// MANIPULATORS
	void Define_Machine_Volume(const TVector3 &pnt_min, const TVector3 &pnt_max);
	
	void Set_Machine(const TMachine &machine);
	void Set_Tool(const TSensor &probe);
	
	void Move_To(const TVector3 &pos) {d_machine_pos = pos;}
	void Path_To(const TVector3 &pos);
	void Add_Touch(const TVector3 &pos);

	void Set_Touch_Buffer_Size(const int buffer_size);
	
protected:

	virtual void GLInit(void);
	virtual void GLResize(const int width, const int height);
	virtual void GLRender(void);

private:
	
struct TTouchPoint
{
	TVector3							pnt;
	std::vector<TVector3>				path;			// path following touch point
};
	
	TVector3							d_min_xyz;
	TVector3							d_max_xyz;
	TVector3							d_axis_draw_pos;
	double								d_axis_draw_len;
	
	TVector3							d_machine_pos;
	
	int									d_touch_buffer_size;
	std::vector<TTouchPoint>			d_touch_buffer;
	
	TOpenGLVertexBuffer					d_opengl_vertex_buffer;
	
	QOpenGLShaderProgram				*d_triangle_shader_program;
	QOpenGLShaderProgram				*d_basic_shader_program;
	
	GLint								d_triangle_uniform_color;
	GLint								d_triangle_uniform_specular;
	GLint								d_triangle_uniform_offset;
	GLint								d_triangle_attribute_vertex;
	GLint								d_triangle_attribute_normal;
	
	GLint								d_basic_uniform_color;
	GLint								d_basic_attribute_vertex;
		
	int									d_machine_z_vertex_id;
	
	int									d_machine_xz_vertex_id;
	int									d_machine_x_vertex_id;
	int									d_machine_xw_vertex_id;
	int									d_machine_table_vertex_id;

	int									d_machine_z_normal_id;
	int									d_machine_xz_normal_id;
	int									d_machine_x_normal_id;
	int									d_machine_xw_normal_id;
	int									d_machine_table_normal_id;
	
	int									d_probe_head_vertex_id;
	int									d_tool_stem_vertex_id;
	int									d_tool_ruby_vertex_id;
	
	int									d_probe_head_normal_id;
	int									d_tool_stem_normal_id;
	int									d_tool_ruby_normal_id;

	int									d_touch_points_id;

	void Update_Path_Buffer(void);
	
	void Render_Triangle_Buffer(const unsigned int size,const TVector3 &offset,const TVector3 &color, const double &specular,double * const vertex,double * const nominal);
	void Render_Line_Buffer(const unsigned int size,const TVector3 &color, double * const vertex);
	void Render_Line_Strip_Buffer(const unsigned int size,const TVector3 &color, double * const vertex);
	void Render_Point_Buffer(const unsigned int size,const TVector3 &color, double * const vertex);
	
	unsigned int Convert_Geometry_To_Buffer(const std::vector<TOpenGLGeometryFactory::TOpenGLTriangleVertex> &data,double ** const vertex,double ** const normal) const;

// NOT IMPLEMENTED
	TOpenGLDisplay(const TOpenGLDisplay&);
	TOpenGLDisplay& operator=(const TOpenGLDisplay&);
};

#endif

