/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef OPENGLDISPLAYWIDGETHEADERFILE
#define OPENGLDISPLAYWIDGETHEADERFILE

#include <vector>
#include <QFrame>
#include <QColor>

#include "../../core/vector3.h"
#include "../../core/vector2.h"

class QToolButton;
class QLabel;
class TOpenGLDisplay;
class TMeasurement;

class TOpenGLDisplayWidget : public QFrame
{
Q_OBJECT

public:

// CREATORS
	TOpenGLDisplayWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TOpenGLDisplayWidget(void);

// ACCESSORS

// MANIPULATORS
	void Define_Machine_Volume(const TVector3 &pnt_min, const TVector3 &pnt_max);
	
	void Set_Tool(const TVector3 &probe_offset,const double &diameter);
	void Set_Tool_Tip_Diameter(const double &diameter) {this->Set_Tool(d_tool_offset,diameter);}
	void Set_Head_AB(const double &a,const double &b);
	
	void Move_To(const TVector3 &pos);
	void Add_Touch(const TVector3 &pos);
	
	void Set_Touch_Buffer_Size(const int buffer_size);
	
	void Update(const bool scale_to_fit);

signals:
	void Model_Item_Clicked(const double&,const double&,const double&,const int);

private slots:
	void Scale_To_Fit_Clicked(void);
	void Rotate_2d_Clicked(bool);
	void Rotate_3d_Clicked(bool);
	void Pan_Clicked(bool);

private:
	
	QToolButton							*d_pan_button;
	QToolButton							*d_rotate_2d_button;
	QToolButton							*d_rotate_3d_button;
	QToolButton							*d_scale_to_fit_button;
	QLabel								*d_gldisplay_error_label;
	TOpenGLDisplay						*d_opengl_display;
	
	TVector3							d_min_xyz;
	TVector3							d_max_xyz;
	TVector3							d_tool_offset;
	double								d_tip_radius;
	double								d_head_angle_a;
	double								d_head_angle_b;
	
	void Draw_Machine(void);
	void Draw_Sensor(void);

// NOT IMPLEMENTED
	TOpenGLDisplayWidget(const TOpenGLDisplayWidget&);
	TOpenGLDisplayWidget& operator=(const TOpenGLDisplayWidget&);
};

#endif
