/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef VIRTUALCMMHEADERFILE
#define VIRTUALCMMHEADERFILE

#include <QMainWindow>
#include <QAbstractSocket>

#include "protocoldialog.h"
#include "machine.h"


class QAction;
//class QDockWidget;
class QPlainTextEdit;
class QSettings;
class QSplitter;
class QTcpServer;
class QTcpSocket;
class QSerialPort;
class QCloseEvent;

class TArtifactContainerWidget;
class TMachineErrorsDialog;
class TMachineDock;
class TOpenGLDisplayWidget;
class TJogboxDialog;
class TCoordinateDisplayWidget;
class TBufferDisplayWidget;
class TMessageBox;

class TMachine;

class TVirtualCMM : public QMainWindow
{
Q_OBJECT

public:

// CREATORS
	TVirtualCMM(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TVirtualCMM(void);

// ACCESSORS

// MANIPULATORS

signals:

private slots:
	
	void Menu_About(void);
	
	void Machine_Attribute_Changed(void);
	void Machine_Touch_Buffer_Changed(int);
	void Machine_Show_Hide_Jogbox(void);
	void Machine_Move_To(const double&,const double&,const double&);	// x,y,z
	void Machine_Enable_Errors_State_Changed(const bool);
	void Machine_Override_Tip_State_Changed(const bool);
	void Machine_Override_Tip_Diameter_Changed(const double&);
	void Machine_Override_Noise_State_Changed(const bool);
	void Machine_Override_Noise_Value_Changed(const double&);
	
	void Machine_Position_Changed(const double&,const double&, const double&);	// x,y,z
	void Machine_Touch_Complete(const double&,const double&, const double&);	// x,y,z
	void Machine_Sensor_Changed(const double&,const double&,const double&,const double&);		// XYZD
	void Machine_Head_AB_Changed(const double&,const double&);							// AB
	void Machine_Add_Manual_Touch(const double&,const double&,const double&,const double&,const double&,const double&,const bool);	// xyzijk,ballbar pre-compensation

	void Machine_Change_Protocol(void);
	void Machine_Edit_Errors(void);

	void Jogbox_MStart_Pressed(void);
	void Jogbox_DelPnt_Pressed(void);
	void Jogbox_Done_Pressed(void);
	void Jogbox_EStop_Pressed(void);
	
	void Jogbox_Move_XM(void);
	void Jogbox_Move_XP(void);
	void Jogbox_Move_YP(void);
	void Jogbox_Move_YM(void);
	void Jogbox_Move_ZM(void);
	void Jogbox_Move_ZP(void);
	
	void New_Connection_Serial(void);
	void New_Connection_Ethernet(void);
	void Closed_Connection(void);
	void Connection_Error(QAbstractSocket::SocketError);
	
	void Ready_Read(void);
	void Send(const QByteArray&);
	void Log_Rx(const QString&);
	void Log_Text(const QString&);
	
protected:
	virtual void closeEvent(QCloseEvent *event);
	

private:
	TArtifactContainerWidget			*d_artifact_container_widget;
	TMachineDock						*d_machine_dock;
	TOpenGLDisplayWidget				*d_opengl_display_widget;
	TBufferDisplayWidget				*d_communication_buffer_widget;
	TMachineErrorsDialog				*d_machine_errors_dialog;
	QAction								*d_file_quit_action;
	QAction								*d_help_about_action;
	QSplitter							*d_splitter_widget;
	QPlainTextEdit						*d_message_log;
	QTcpServer							*d_tcp_server;
	QTcpSocket							*d_tcp_socket;
	QSerialPort							*d_serial_port;
	TJogboxDialog						*d_jogbox_dialog;
	TProtocolDialog						*d_protocol_dialog;
	TCoordinateDisplayWidget			*d_coordinate_display_widget;
	TMessageBox							*d_msg_box;
		
	QSettings							*d_settings;
	QString								d_application_path;
	QString								d_data_path;
	double								d_machine_scale_factor_x;
	double								d_machine_scale_factor_y;
	double								d_machine_scale_factor_z;
	double								d_machine_squareness_xy;
	double								d_machine_squareness_yz;
	double								d_machine_squareness_zx;

	TMachine							*d_machine;
	TProtocolDialog::TControllerType	d_active_controller_type;
	
	void Initialize_Machine(void);

	void Clear_Log(void);
	void Add_Log_Text(const QString&);


// NOT IMPLEMENTED
	TVirtualCMM(const TVirtualCMM&);
	TVirtualCMM& operator=(const TVirtualCMM&);
};

#endif
